// // // // // // // // // // // // // // // // // // // //
//	
//	Connection Data
//	
//	created Apr/13/98 by Andreas Warnke
//	last mod Apr/13/98 by Andreas Warnke
//	



// // // // // // // // // // // // // // // // // // // //
//	
//	#include
//

#include <Be.h>
#include "ConnectionData.h"



// // // // // // // // // // // // // // // // // // // //
//	
//	Constructor
//

ConnectionData :: ConnectionData ()
{
	//	BMessenger TheServer:
	//	Constructor is called automatically.
	
	//	Name and password of the Agent
	TheName = NULL;
	ThePassword = NULL;
	TheReadOnlyPassword = NULL;
	ThePlayerID = 0;
	
	//	Connection- and Game-Status
	LoggedIn = false;
	GameFinished = false;
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Destructor
//

ConnectionData :: ~ConnectionData ()
{
	//	free occupied memory:
	DeleteNameAndPasswords ();
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Free occupied memory:
//

void ConnectionData :: DeleteNameAndPasswords ()
{
	if ( TheName != NULL )
	{
		//	TheName exists.
		delete [] TheName;
		TheName = NULL;
	};
	
	if ( ThePassword != NULL )
	{
		//	ThePassword exists.
		delete [] ThePassword;
		ThePassword = NULL;
	};
	
	if ( TheReadOnlyPassword != NULL )
	{
		//	TheReadOnlyPassword exists.
		delete [] TheReadOnlyPassword;
		TheReadOnlyPassword = NULL;
	};
	
	//	Because neither ThePassword nor TheName exists
	//	the client is no longer logged in.
	LoggedIn = false;
};



//	
//	The End.
//	
// // // // // // // // // // // // // // // // // // // //
